<?php
/**
*Ȩ ţcms
*ٷַ www.niubicms.com
*汾 2014-10-31 16:50
**/
class dm
{
	private $db;
	private $table;
	private $bm_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->table=LA_PRE.'dm';
		$this->bm_table=LA_PRE.'dm_bm';
	}

	function dmlist($status=0,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$status=intval($status);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>0?' AND status='.$status:'';
		$where.=$starttime?' AND datetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND datetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function dmstatis($status=-1)
	{
		global $siteidobj,$_siteid;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>0?' AND status='.$status:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->table` WHERE $where");
	}

	function getdm($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->table` WHERE `$this->table`.`id`=$id");
	}

	function dmname($id)
	{
		$r=$this->getdm($id);
		return $r?$r['title']:'-';
	}

	function baseset($info,$ids)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			$this->db->update($this->table,$info,'id='.intval($id));
		}

		return true;
	}

	function delete($ids)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			$this->db->mysql_delete($this->table,$id);
		}

		return true;
	}

	function formatdmurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-dm-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$coninfo=$this->getdm($id);

			$modinfo=$moduleobj->get(intval($coninfo['moduleid']));
			$modsettings=$configobj->getconfig($_SESSION['siteid'],$coninfo['moduleid']);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'dm-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=showdm&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/dm-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=showdm&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function dm_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}
	
	function dm_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function bmlist($id=0)
	{
		global $page,$_siteid,$siteidobj;
		$id=intval($id);
		$where=$id?'dmid='.$id:'1';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='dmid DESC,id ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->bm_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}
	
	function bm_delete($ids)
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			$this->db->mysql_delete($this->bm_table,$id);
		}

		return true;
	}

	function bmstatis($id=0)
	{
		global $siteidobj,$_siteid;
		$id=intval($id);
		$where=$id?'dmid='.$id:'1';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->bm_table` WHERE $where");
	}
	
	function getbm($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->bm_table` WHERE `$this->bm_table`.`id`=$id");
	}

	function bm_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}
	
	function bm_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->bm_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function bmdata($id)
	{
		return $this->db->fetch_all("SELECT * FROM `$this->bm_table` WHERE `$this->bm_table`.`dmid`=$id");
	}
}
?>